<?xml version="1.0" encoding="UTF-8" ?>
<!DOCTYPE xsl:stylesheet [
<!ENTITY lsquor   "&#x201A;" ><!--=rising single quote, left (low)-->
<!ENTITY ldquor   "&#x201E;" ><!--=rising dbl quote, left (low)-->
<!ENTITY rdquor   "&#x201D;" ><!--rising dbl quote, right (high)-->
<!ENTITY rsquor   "&#x2019;" ><!--rising single quote, right (high)-->
<!ENTITY ldquo    "&#x201C;"  ><!--=double quotation mark, left-->
<!ENTITY rdquo    "&#x201D;"  ><!--=double quotation mark, right-->
]>
<xsl:stylesheet 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:t="http://www.tei-c.org/ns/1.0"
    xmlns="http://www.w3.org/1999/xhtml" 
    xmlns:os="http://a9.com/-/spec/opensearch/1.1/"
    xmlns:k="http://www.kb.dk/searchDesc/1.0"
    xmlns:atom="http://www.w3.org/2005/Atom"
    exclude-result-prefixes="t os k atom"
    version="1.0">

  <xsl:output method="xml"
	      encoding="UTF-8"
	      indent="yes"/>

  <xsl:param
      name="query"
      select="/t:TEI/t:teiHeader/k:searchDesc/os:Query/@Query"/>



  <xsl:template match="/">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="t:TEI">
    <xsl:element name="html">
      <xsl:element name="head">
	<xsl:element name="meta">
	  <xsl:attribute name="http-equiv">Content-Type</xsl:attribute>
	  <xsl:attribute name="content">text/html;charset=UTF-8</xsl:attribute>
	</xsl:element>
	<xsl:element name="title">
	  <xsl:apply-templates select="t:teiHeader/t:fileDesc/t:titleStmt/t:title"/>
	</xsl:element>
	<style type="text/css" media="all"><xsl:text>
	  @import "html_print.css";
	</xsl:text></style>

      </xsl:element>
      <xsl:element name="body">
	<xsl:call-template name="previous_next"/>	
	<xsl:element name="table">
	  <xsl:for-each select="//t:div">
	    <xsl:apply-templates select="."/>
	  </xsl:for-each>
	</xsl:element>
	<xsl:call-template name="previous_next"/>	
      </xsl:element>
    </xsl:element>
  </xsl:template>

  <xsl:template match="t:div">
    <xsl:apply-templates select="t:p"/>
  </xsl:template>

  <xsl:template match="t:p">
    <xsl:element name="tr">
      <xsl:apply-templates select="t:phr[t:ref]"/>
    </xsl:element>
  </xsl:template>

  <xsl:template match="t:phr[t:ref]">
    <xsl:apply-templates select="t:ref"/>
  </xsl:template>

  <xsl:template match="t:phr[@part]">
    <xsl:param name="href"/>
    <xsl:apply-templates select="t:w">
      <xsl:with-param name="href" select="$href"/>
    </xsl:apply-templates>
  </xsl:template>

  <xsl:template match="t:ref">
    <xsl:element name="td">
      <xsl:attribute name="style">text-align:right;</xsl:attribute>
      <xsl:apply-templates select="t:phr[@part='I']">
	<xsl:with-param name="href" select="@target"/>
      </xsl:apply-templates>
    </xsl:element>
    <xsl:element name="td">
      <xsl:attribute name="style">text-align:center;</xsl:attribute>
      <xsl:element name="strong">
	<xsl:apply-templates select="t:phr[@part='M']">
	  <xsl:with-param name="href" select="@target"/>
	</xsl:apply-templates>
      </xsl:element>
    </xsl:element>
    <xsl:element name="td">
      <xsl:attribute name="style">text-align:left;</xsl:attribute>
      <xsl:apply-templates select="t:phr[@part='F']">
	<xsl:with-param name="href" select="@target"/>
      </xsl:apply-templates>
    </xsl:element>
  </xsl:template>

  <xsl:template match="t:w">
    <xsl:param name="href"/>
    <xsl:element name="a">
      <xsl:attribute name="href"><xsl:value-of select="$href"/></xsl:attribute>
      <xsl:apply-templates/>
    </xsl:element><xsl:text>
    </xsl:text>
  </xsl:template>

<xsl:template name="previous_next">
    <p>
      <xsl:variable
          name="current"
          select="/t:TEI/t:teiHeader/k:searchDesc/os:startPage"/>

      <xsl:variable
          name="last"
          select="ceiling(/t:TEI/t:teiHeader/k:searchDesc/os:totalResults div
		          /t:TEI/t:teiHeader/k:searchDesc/os:itemsPerPage)"/>


      <xsl:choose>
        <xsl:when test="$current = 1">
          <xsl:text>|&lt;</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:element name="a">
            <xsl:attribute name="title">Første side</xsl:attribute>
            <xsl:attribute name="href">
	      <xsl:value-of
		  select="concat('?query=',$query,'&amp;page=',1)"/>
          </xsl:attribute>|&lt;</xsl:element>
        </xsl:otherwise>
      </xsl:choose>

      <xsl:text>
      </xsl:text>

      <strong><xsl:choose>
        <xsl:when test="$current - 1 &gt; 0">
          <xsl:element name="a">
            <xsl:attribute name="href">
	      <xsl:value-of
		  select="concat('?query=',$query,'&amp;page=',$current - 1)"/>
          </xsl:attribute>Forrige</xsl:element>
        </xsl:when>
        <xsl:otherwise>Forrige</xsl:otherwise>
      </xsl:choose></strong>
      <xsl:text> ( </xsl:text>
      <xsl:call-template name="page_navigation">
        <xsl:with-param name="start">1</xsl:with-param>
        <xsl:with-param
            name="current"
            select="/t:TEI/t:teiHeader/k:searchDesc/os:startPage"/>
        <xsl:with-param
            name="total_pages"
            select="$last"/>
      </xsl:call-template>
      <xsl:text> ) </xsl:text>
      <strong><xsl:choose>
        <xsl:when test="$current &lt; $last">
          <xsl:element name="a">
            <xsl:attribute name="href">
	      <xsl:value-of
		  select="concat('?query=',$query,'&amp;page=',$current + 1)"/>
          </xsl:attribute>Næste</xsl:element>
        </xsl:when>
        <xsl:otherwise>Næste</xsl:otherwise>
      </xsl:choose></strong>
      <xsl:text>
      </xsl:text>
      <xsl:choose>
        <xsl:when test="$current = $last">
          <xsl:text>&gt;|</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:element name="a">
            <xsl:attribute name="title">Sidste side</xsl:attribute>
            <xsl:attribute name="href">
	      <xsl:if test="$query">
		<xsl:value-of
                      select="concat('?query=',$query,'&amp;page=',$last)"/>
	      </xsl:if>
          </xsl:attribute>&gt;|</xsl:element>
        </xsl:otherwise>
      </xsl:choose>

      <xsl:text>
      </xsl:text>
    </p>
  </xsl:template>

  <xsl:template name="page_navigation">
    <xsl:param name="start"/>
    <xsl:param name="current"/>
    <xsl:param name="total_pages"/>

    <xsl:if test="$start &gt; ($current - 5) and $start &lt; ($current + 5)">
      <xsl:text>
      </xsl:text>
      <xsl:choose>
        <xsl:when test="$current = $start">
          <xsl:value-of select="$start"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:element name="a">
            <xsl:attribute name="href">
	      <xsl:value-of
		  select="concat('?query=',$query,'&amp;page=',$start)"/>
            </xsl:attribute>
            <xsl:value-of select="$start"/>
          </xsl:element>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:text>
      </xsl:text>
    </xsl:if>
    <xsl:if test="$start+1&lt;=$total_pages">
      <xsl:call-template name="page_navigation">
        <xsl:with-param name="start"><xsl:value-of select="$start+1"/></xsl:with-param>
        <xsl:with-param name="current"><xsl:value-of select="$current"/></xsl:with-param>
        <xsl:with-param name="total_pages" ><xsl:value-of select="$total_pages"/></xsl:with-param>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>



</xsl:stylesheet>
