#!/usr/bin/perl -w

use strict;

use URI::Escape;
require LWP::UserAgent;
use XML::LibXML;
use XML::LibXSLT;
use Encode;

binmode STDOUT,":utf8";

my $tag_serv  = 'http://mail.cst.dk/dkclarintools/index.php#output';
my $parser    = new XML::LibXML;
my $xslt      = new XML::LibXSLT;
my $transfile = 'tag_sheet.xsl';
my $style_doc = $parser->parse_file($transfile);
my $sourcedoc = $parser->parse_file($ARGV[0]);
my $ua        = new LWP::UserAgent;

$xslt->register_function("http://www.kb.dk/namespaces/tagfunction/",
			 "cst_tagger",
			 sub {
			     my $text = shift;
			     my $str = &call_tagger($text);
			     return $str;
			 }
			 );

my $transformer = $xslt->parse_stylesheet($style_doc);
my $result      = $transformer->transform($sourcedoc);
print $transformer->output_string($result);

sub call_tagger {
    my $string = shift;

    my $file = './tempfile.txt';
    my %form   = ('password'  => 'regn',
		  'language'  => 'da',
		  'token'     => 'j',
		  "navne"     => "j",
		  "anonym"    => "n",
		  "pos"       => "j",
		  "lemma"     => "n",
		  "dict"      => "n",
		  "indict"    => "n",
		  "ambi"      => "n",
		  "what"      => "word-lemma",
		  "abbr"      => "j",
		  "mwu"       => "j",
		  'inputText' => encode('ISO-8859-1',$string->string_value()),
		  #'inputFile' => [undef,$file,
#				  'Content_type'=>'text/plain;charset=UTF-8',
#				  'Content'=>$string->string_value()],
		  );

    my $ua = new LWP::UserAgent;
    my $response = $ua->post($tag_serv,\%form,'Content_type' => 'form-data');

    # print $response->request->as_string;
    # print  decode('UTF-8',$response->as_string);

    if ($response->is_success) {
	my $content  = $response->content;
	my @tokens   = split /\s+/, $content;
	my $div      = XML::LibXML::Element->new('div');
	$div->setAttribute('type','ignore');
	foreach my $token (@tokens) {
	    my ($val,$tag) = split '/',$token;
	    my $node = XML::LibXML::Element->new('w');
	    $node->appendTextNode($val);
	    if($tag) {
		$node->setAttribute('ana',$tag);
	    }
	    $div->addChild($node);
	}
	return $div;
    }
    else {
	die $response->status_line;
    }
}
